/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import noppes.npcs.NBTTags;
import noppes.npcs.api.constants.JobType;
import noppes.npcs.api.entity.data.role.IJobGuard;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;

public class JobGuard
extends JobInterface
implements IJobGuard {
    public final List<String> targets = new ArrayList<String>();

    public JobGuard(EntityNPCInterface npc) {
        super(npc);
        this.type = JobType.GUARD;
    }

    public boolean isEntityApplicable(Entity entity) {
        return !(entity instanceof EntityPlayer) && !(entity instanceof EntityNPCInterface) && this.targets.contains("entity." + EntityList.func_75621_b((Entity)entity) + ".name");
    }

    @Override
    public boolean isWorking() {
        return !this.targets.isEmpty() && this.npc.isAttacking();
    }

    @Override
    public void load(NBTTagCompound compound) {
        String name;
        Class cl;
        super.load(compound);
        this.type = JobType.GUARD;
        this.targets.clear();
        this.targets.addAll(NBTTags.getStringList(compound.func_150295_c("GuardTargets", 10)));
        if (compound.func_74767_n("GuardAttackAnimals")) {
            for (EntityEntry ent : ForgeRegistries.ENTITIES.getValuesCollection()) {
                cl = ent.getEntityClass();
                name = "entity." + ent.getName() + ".name";
                if (!EntityAnimal.class.isAssignableFrom(cl) || this.targets.contains(name)) continue;
                this.targets.add(name);
            }
        }
        if (compound.func_74767_n("GuardAttackMobs")) {
            for (EntityEntry ent : ForgeRegistries.ENTITIES.getValuesCollection()) {
                cl = ent.getEntityClass();
                name = "entity." + ent.getName() + ".name";
                if (!EntityMob.class.isAssignableFrom(cl) || EntityCreeper.class.isAssignableFrom(cl) || this.targets.contains(name)) continue;
                this.targets.add(name);
            }
        }
        if (compound.func_74767_n("GuardAttackCreepers")) {
            for (EntityEntry ent : ForgeRegistries.ENTITIES.getValuesCollection()) {
                cl = ent.getEntityClass();
                name = "entity." + ent.getName() + ".name";
                if (!EntityCreeper.class.isAssignableFrom(cl) || this.targets.contains(name)) continue;
                this.targets.add(name);
            }
        }
    }

    @Override
    public NBTTagCompound save(NBTTagCompound compound) {
        super.load(compound);
        compound.func_74782_a("GuardTargets", (NBTBase)NBTTags.nbtStringList(this.targets));
        return compound;
    }
}

